﻿<?php 
/*
# ------------------------------------------------------------------------
# Extensions for Joomla 2.5.x - Joomla 3.x
# ------------------------------------------------------------------------
# Copyright (C) 2011-2015 Ext-Joom.com. All Rights Reserved.
# @license - PHP files are GNU/GPL V2.
# Author: Ext-Joom.com
# Websites:  http://www.ext-joom.com 
# Date modified: 02/03/2015 - 13:00
# ------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die;
$document 					= JFactory::getDocument();
$module_id 					= "mod_" . $module->id;
$moduleclass_sfx			= $params->get('moduleclass_sfx');
$document->addStyleSheet(JURI::base() . 'modules/mod_ext_quick_contact_form_jquery/assets/css/default.css');

// reCaptcha
require_once ("recaptchalib.php");

// Get a key from https://www.google.com/recaptcha/admin/create
$publickey 				= $params->get('publickey');
$privatekey				= $params->get('privatekey');
$ext_recaptcha_message	= $params->get('ext_recaptcha_message');

//reCAPTCHA supported 40+ languages listed here: https://developers.google.com/recaptcha/docs/language
$ext_recaptcha_lang			= $params->get('ext_recaptcha_lang', 'en');

# the response from reCAPTCHA
$resp = null;
# the error code from reCAPTCHA, if any
$error = null;
# ReCaptcha
$reCaptcha = new ReCaptcha($privatekey);


// params
$ext_jquery_ver				= $params->get('ext_jquery_ver', '1.9.1');
$ext_load_jquery			= (int)$params->get('ext_load_jquery', 1);
$ext_load_validate			= (int)$params->get('ext_load_validate', 1);

$ext_my_email				= $params->get('ext_my_email');
$ext_name_label				= $params->get('ext_name_label', 'Name:');
$ext_email_label			= $params->get('ext_email_label', 'e-mail:');
$ext_subject_label			= $params->get('ext_subject_label', 'Subject:');
$ext_message_label			= $params->get('ext_message_label', 'Message:');
$ext_send_label				= $params->get('ext_send_label', 'Send');
$ext_send_message			= $params->get('ext_send_message');
$ext_error_email			= $params->get('ext_error_email');
$ext_error_field			= $params->get('ext_error_field');
$ext_script_required		= $params->get('ext_script_required');
$ext_script_email			= $params->get('ext_script_email');
$ext_script_minlength		= $params->get('ext_script_minlength');



$ext_script = <<<SCRIPT


var jQowl = false;
function initJQ() {
	if (typeof(jQuery) == 'undefined') {
		if (!jQowl) {
			jQowl = true;
			document.write('<scr' + 'ipt type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/$ext_jquery_ver/jquery.min.js"></scr' + 'ipt>');
		}
		setTimeout('initJQ()', 500);
	}
}
initJQ(); 
 
 if (jQuery) jQuery.noConflict();    
  
  

SCRIPT;

if ($ext_load_jquery  > 0) {
	$document->addScriptDeclaration($ext_script);	
}
if ($ext_load_validate  > 0) { 
	$document->addCustomTag('<script type = "text/javascript" src = "'.JURI::root().'modules/mod_ext_quick_contact_form_jquery/assets/js/jquery.validate.min.js"></script>'); 
}


$errMsg  = '';
$name    = '';
$email   = '';
$subject = ''; 
$message = '';


if ($publickey == '' OR $privatekey == '') {
	$errMsg = '<p> To use reCAPTCHA you must get an API key from https://www.google.com/recaptcha/admin/create </p>';
}

// clear data 
function clearData ($data, $type="string") {
	switch ($type) {
		case "string": 
					return trim(strip_tags($data));
					break;
		case "string_msg":
					return trim(htmlspecialchars($data,ENT_QUOTES));
					break;
		case "int":
					return (int)$data;
					break;
	}
}

// check email
function isEmail($email) {
	return(preg_match("/^[-_.[:alnum:]]+@((([[:alnum:]]|[[:alnum:]][[:alnum:]-]*[[:alnum:]])\.)+(ad|ae|aero|af|ag|ai|al|am|an|ao|aq|ar|arpa|as|at|au|aw|az|ba|bb|bd|be|bf|bg|bh|bi|biz|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|com|coop|cr|cs|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|ec|edu|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gh|gi|gl|gm|gn|gov|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|in|info|int|io|iq|ir|is|it|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|mil|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|museum|mv|mw|mx|my|mz|na|name|nc|ne|net|nf|ng|ni|nl|no|np|nr|nt|nu|nz|om|org|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|pro|ps|pt|pw|py|qa|re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|um|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw)$|(([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\.){3}([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5]))$/i"
					,$email));
}

require JModuleHelper::getLayoutPath('mod_ext_quick_contact_form_jquery', $params->get('layout', 'default'));
?>